package com.ejie.ab04b.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VosalanOs4Os6;
import com.ejie.ab04b.util.Utilities;

/**
 * VosalanOs4Os6DaoImpl generated by UDA, 16-jun-2017 13:27:17.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VosalanOs4Os6DaoImpl implements VosalanOs4Os6Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VosalanOs4Os6> rwMap = new RowMapper<VosalanOs4Os6>() {
		public VosalanOs4Os6 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VosalanOs4Os6(resultSet.getString("TIPOOS"),
					resultSet.getInt("CODCTR"), resultSet.getInt("NUMDOC"),
					resultSet.getLong("CODANO"), resultSet.getString("CODPRO"),
					resultSet.getInt("NUMEJE"), resultSet.getDate("FECVIS"),
					resultSet.getString("CODTEC"),
					resultSet.getString("OBSERV"),
					resultSet.getString("CODUSA"), resultSet.getDate("FECUSA"),
					resultSet.getString("CODUSM"), resultSet.getDate("FECUSM"),
					resultSet.getInt("NUMEXP"), resultSet.getString("NOMPRO"),
					resultSet.getString("NOMCON"),
					resultSet.getString("AVIPRE"),
					resultSet.getString("COMAPE"),
					resultSet.getString("PLASEG"),
					resultSet.getString("NOMCOO"),
					resultSet.getString("EMPCON"),
					resultSet.getString("EMPSUB"),
					resultSet.getString("EMPAUT"),
					resultSet.getString("EMPNOM"),
					resultSet.getString("NOMRE1"),
					resultSet.getString("DESRE1"),
					resultSet.getString("NOMRE2"),
					resultSet.getString("DESRE2"),
					resultSet.getString("NOMRE3"),
					resultSet.getString("DESRE3"),
					resultSet.getString("NOMREP"),
					resultSet.getString("DESREP"),
					resultSet.getString("EMPPRO"),
					resultSet.getString("CCAU01"),
					resultSet.getString("CCAU02"),
					resultSet.getString("CCAU03"),
					resultSet.getString("CCAU04"),
					resultSet.getString("CCAU05"),
					resultSet.getString("CCAU06"),
					resultSet.getString("CCAU07"),
					resultSet.getString("CCAU08"),
					resultSet.getString("CCAU09"),
					resultSet.getString("CCAU10"),
					resultSet.getString("DIROBR"), resultSet.getDate("FECREV"),
					resultSet.getBigDecimal("NUMVIS"),
					resultSet.getString("NUECEN"),
					resultSet.getString("CODMOD"),
					resultSet.getString("MOPEMP"),
					resultSet.getString("FOREMP"),
					resultSet.getString("MOPTRA"),
					resultSet.getBigDecimal("NUMTRA"),
					resultSet.getString("FORTRA"),
					resultSet.getBigDecimal("NUMTRF"),
					resultSet.getString("MOPSPP"),
					resultSet.getString("SEGSPP"),
					resultSet.getString("HIGSPP"),
					resultSet.getString("ERGSPP"),
					resultSet.getString("MEDSPP"),
					resultSet.getString("MOPSPA"),
					resultSet.getString("NOMSPA"),
					resultSet.getString("SEGSPA"),
					resultSet.getString("HIGSPA"),
					resultSet.getString("ERGSPA"),
					resultSet.getString("MEDSPA"),
					resultSet.getString("COMSYS"),
					resultSet.getBigDecimal("NUMCOE"),
					resultSet.getBigDecimal("NUMCOT"),
					resultSet.getString("DELPRE"),
					resultSet.getBigDecimal("NUMDEL"),
					resultSet.getString("FORDEL"),
					resultSet.getBigDecimal("NUMDEF"),
					resultSet.getString("CODMER"),
					resultSet.getString("INDRER"),
					resultSet.getString("REREMO"),
					resultSet.getString("RERTRA"),
					resultSet.getString("RERSPP"),
					resultSet.getString("RERSPA"),
					resultSet.getString("REROTR"),
					resultSet.getString("DEROTR"),
					resultSet.getString("FIRMER"),
					resultSet.getString("PARDEL"),
					resultSet.getString("PARTRA"),
					resultSet.getString("CONDEL"),
					resultSet.getString("TRAINF"),
					resultSet.getString("MEDPLA"),
					resultSet.getString("MEDRES"),
					resultSet.getString("MEDFEC"),
					resultSet.getString("MEDPRE"),
					resultSet.getString("CODMME"),
					resultSet.getString("MEPLAC"),
					resultSet.getString("CONTRA"),
					resultSet.getString("MESIMU"),
					resultSet.getString("RMEEMP"),
					resultSet.getString("RMETRA"),
					resultSet.getString("RMESPP"),
					resultSet.getString("RMESPA"),
					resultSet.getString("RMEOTR"),
					resultSet.getString("DMEOTR"),
					resultSet.getString("FORTRP"),
					resultSet.getString("VIGSAL"),
					resultSet.getString("TRASEN"),
					resultSet.getString("TRAMEN"),
					resultSet.getString("TRAMAT"),
					resultSet.getString("INFNUE"),
					resultSet.getString("PLAACO"), resultSet.getString("NOTAS"),
					resultSet.getString("NMUTUA"));
		}
	};

	private RowMapper<VosalanOs4Os6> rwMapPK = new RowMapper<VosalanOs4Os6>() {
		public VosalanOs4Os6 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VosalanOs4Os6(resultSet.getString("TIPOOS"),
					resultSet.getInt("CODCTR"), resultSet.getInt("NUMDOC"),
					resultSet.getLong("CODANO"), resultSet.getString("CODPRO"),
					resultSet.getInt("NUMEJE"), resultSet.getDate("FECVIS"),
					resultSet.getString("CODTEC"),
					resultSet.getString("OBSERV"),
					resultSet.getString("CODUSA"), resultSet.getDate("FECUSA"),
					resultSet.getString("CODUSM"), resultSet.getDate("FECUSM"),
					resultSet.getInt("NUMEXP"), resultSet.getString("NOMPRO"),
					resultSet.getString("NOMCON"),
					resultSet.getString("AVIPRE"),
					resultSet.getString("COMAPE"),
					resultSet.getString("PLASEG"),
					resultSet.getString("NOMCOO"),
					resultSet.getString("EMPCON"),
					resultSet.getString("EMPSUB"),
					resultSet.getString("EMPAUT"),
					resultSet.getString("EMPNOM"),
					resultSet.getString("NOMRE1"),
					resultSet.getString("DESRE1"),
					resultSet.getString("NOMRE2"),
					resultSet.getString("DESRE2"),
					resultSet.getString("NOMRE3"),
					resultSet.getString("DESRE3"),
					resultSet.getString("NOMREP"),
					resultSet.getString("DESREP"),
					resultSet.getString("EMPPRO"),
					resultSet.getString("CCAU01"),
					resultSet.getString("CCAU02"),
					resultSet.getString("CCAU03"),
					resultSet.getString("CCAU04"),
					resultSet.getString("CCAU05"),
					resultSet.getString("CCAU06"),
					resultSet.getString("CCAU07"),
					resultSet.getString("CCAU08"),
					resultSet.getString("CCAU09"),
					resultSet.getString("CCAU10"),
					resultSet.getString("DIROBR"), resultSet.getDate("FECREV"),
					resultSet.getBigDecimal("NUMVIS"),
					resultSet.getString("NUECEN"),
					resultSet.getString("CODMOD"),
					resultSet.getString("MOPEMP"),
					resultSet.getString("FOREMP"),
					resultSet.getString("MOPTRA"),
					resultSet.getBigDecimal("NUMTRA"),
					resultSet.getString("FORTRA"),
					resultSet.getBigDecimal("NUMTRF"),
					resultSet.getString("MOPSPP"),
					resultSet.getString("SEGSPP"),
					resultSet.getString("HIGSPP"),
					resultSet.getString("ERGSPP"),
					resultSet.getString("MEDSPP"),
					resultSet.getString("MOPSPA"),
					resultSet.getString("NOMSPA"),
					resultSet.getString("SEGSPA"),
					resultSet.getString("HIGSPA"),
					resultSet.getString("ERGSPA"),
					resultSet.getString("MEDSPA"),
					resultSet.getString("COMSYS"),
					resultSet.getBigDecimal("NUMCOE"),
					resultSet.getBigDecimal("NUMCOT"),
					resultSet.getString("DELPRE"),
					resultSet.getBigDecimal("NUMDEL"),
					resultSet.getString("FORDEL"),
					resultSet.getBigDecimal("NUMDEF"),
					resultSet.getString("CODMER"),
					resultSet.getString("INDRER"),
					resultSet.getString("REREMO"),
					resultSet.getString("RERTRA"),
					resultSet.getString("RERSPP"),
					resultSet.getString("RERSPA"),
					resultSet.getString("REROTR"),
					resultSet.getString("DEROTR"),
					resultSet.getString("FIRMER"),
					resultSet.getString("PARDEL"),
					resultSet.getString("PARTRA"),
					resultSet.getString("CONDEL"),
					resultSet.getString("TRAINF"),
					resultSet.getString("MEDPLA"),
					resultSet.getString("MEDRES"),
					resultSet.getString("MEDFEC"),
					resultSet.getString("MEDPRE"),
					resultSet.getString("CODMME"),
					resultSet.getString("MEPLAC"),
					resultSet.getString("CONTRA"),
					resultSet.getString("MESIMU"),
					resultSet.getString("RMEEMP"),
					resultSet.getString("RMETRA"),
					resultSet.getString("RMESPP"),
					resultSet.getString("RMESPA"),
					resultSet.getString("RMEOTR"),
					resultSet.getString("DMEOTR"),
					resultSet.getString("FORTRP"),
					resultSet.getString("VIGSAL"),
					resultSet.getString("TRASEN"),
					resultSet.getString("TRAMEN"),
					resultSet.getString("TRAMAT"),
					resultSet.getString("INFNUE"),
					resultSet.getString("PLAACO"), resultSet.getString("NOTAS"),
					resultSet.getString("NMUTUA"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VosalanOs4Os6 table.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  VosalanOs4Os6
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @return the vosalan os 4 os 6
	 */
	public VosalanOs4Os6 add(VosalanOs4Os6 vosalanos4os6) {
		String query = "INSERT INTO VOSALAN_OS4_OS6 (TIPOOS, CODCTR, NUMDOC, CODANO, CODPRO, NUMEJE, FECVIS, CODTEC, OBSERV, CODUSA, FECUSA, CODUSM, FECUSM, NUMEXP, NOMPRO, NOMCON, AVIPRE, COMAPE, PLASEG, NOMCOO, EMPCON, EMPSUB, EMPAUT, EMPNOM, NOMRE1, DESRE1, NOMRE2, DESRE2, NOMRE3, DESRE3, NOMREP, DESREP, EMPPRO, CCAU01, CCAU02, CCAU03, CCAU04, CCAU05, CCAU06, CCAU07, CCAU08, CCAU09, CCAU10, DIROBR, FECREV, NUMVIS, NUECEN, CODMOD, MOPEMP, FOREMP, MOPTRA, NUMTRA, FORTRA, NUMTRF, MOPSPP, SEGSPP, HIGSPP, ERGSPP, MEDSPP, MOPSPA, NOMSPA, SEGSPA, HIGSPA, ERGSPA, MEDSPA, COMSYS, NUMCOE, NUMCOT, DELPRE, NUMDEL, FORDEL, NUMDEF, CODMER, INDRER, REREMO, RERTRA, RERSPP, RERSPA, REROTR, DEROTR, FIRMER, PARDEL, PARTRA, CONDEL, TRAINF, MEDPLA, MEDRES, MEDFEC, MEDPRE, CODMME, MEPLAC, CONTRA, MESIMU, RMEEMP, RMETRA, RMESPP, RMESPA, RMEOTR, DMEOTR, FORTRP, VIGSAL, TRASEN, TRAMEN, TRAMAT, INFNUE, PLAACO, NOTAS, NMUTUA) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vosalanos4os6.getTipoos(),
				vosalanos4os6.getCodctr(), vosalanos4os6.getNumdoc(),
				vosalanos4os6.getCodano(), vosalanos4os6.getCodpro(),
				vosalanos4os6.getNumeje(), vosalanos4os6.getFecvis(),
				vosalanos4os6.getCodtec(), vosalanos4os6.getObserv(),
				vosalanos4os6.getCodusa(), vosalanos4os6.getFecusa(),
				vosalanos4os6.getCodusm(), vosalanos4os6.getFecusm(),
				vosalanos4os6.getNumexp(), vosalanos4os6.getNompro(),
				vosalanos4os6.getNomcon(), vosalanos4os6.getAvipre(),
				vosalanos4os6.getComape(), vosalanos4os6.getPlaseg(),
				vosalanos4os6.getNomcoo(), vosalanos4os6.getEmpcon(),
				vosalanos4os6.getEmpsub(), vosalanos4os6.getEmpaut(),
				vosalanos4os6.getEmpnom(), vosalanos4os6.getNomre1(),
				vosalanos4os6.getDesre1(), vosalanos4os6.getNomre2(),
				vosalanos4os6.getDesre2(), vosalanos4os6.getNomre3(),
				vosalanos4os6.getDesre3(), vosalanos4os6.getNomrep(),
				vosalanos4os6.getDesrep(), vosalanos4os6.getEmppro(),
				vosalanos4os6.getCcau01(), vosalanos4os6.getCcau02(),
				vosalanos4os6.getCcau03(), vosalanos4os6.getCcau04(),
				vosalanos4os6.getCcau05(), vosalanos4os6.getCcau06(),
				vosalanos4os6.getCcau07(), vosalanos4os6.getCcau08(),
				vosalanos4os6.getCcau09(), vosalanos4os6.getCcau10(),
				vosalanos4os6.getDirobr(), vosalanos4os6.getFecrev(),
				vosalanos4os6.getNumvis(), vosalanos4os6.getNuecen(),
				vosalanos4os6.getCodmod(), vosalanos4os6.getMopemp(),
				vosalanos4os6.getForemp(), vosalanos4os6.getMoptra(),
				vosalanos4os6.getNumtra(), vosalanos4os6.getFortra(),
				vosalanos4os6.getNumtrf(), vosalanos4os6.getMopspp(),
				vosalanos4os6.getSegspp(), vosalanos4os6.getHigspp(),
				vosalanos4os6.getErgspp(), vosalanos4os6.getMedspp(),
				vosalanos4os6.getMopspa(), vosalanos4os6.getNomspa(),
				vosalanos4os6.getSegspa(), vosalanos4os6.getHigspa(),
				vosalanos4os6.getErgspa(), vosalanos4os6.getMedspa(),
				vosalanos4os6.getComsys(), vosalanos4os6.getNumcoe(),
				vosalanos4os6.getNumcot(), vosalanos4os6.getDelpre(),
				vosalanos4os6.getNumdel(), vosalanos4os6.getFordel(),
				vosalanos4os6.getNumdef(), vosalanos4os6.getCodmer(),
				vosalanos4os6.getIndrer(), vosalanos4os6.getReremo(),
				vosalanos4os6.getRertra(), vosalanos4os6.getRerspp(),
				vosalanos4os6.getRerspa(), vosalanos4os6.getRerotr(),
				vosalanos4os6.getDerotr(), vosalanos4os6.getFirmer(),
				vosalanos4os6.getPardel(), vosalanos4os6.getPartra(),
				vosalanos4os6.getCondel(), vosalanos4os6.getTrainf(),
				vosalanos4os6.getMedpla(), vosalanos4os6.getMedres(),
				vosalanos4os6.getMedfec(), vosalanos4os6.getMedpre(),
				vosalanos4os6.getCodmme(), vosalanos4os6.getMeplac(),
				vosalanos4os6.getContra(), vosalanos4os6.getMesimu(),
				vosalanos4os6.getRmeemp(), vosalanos4os6.getRmetra(),
				vosalanos4os6.getRmespp(), vosalanos4os6.getRmespa(),
				vosalanos4os6.getRmeotr(), vosalanos4os6.getDmeotr(),
				vosalanos4os6.getFortrp(), vosalanos4os6.getVigsal(),
				vosalanos4os6.getTrasen(), vosalanos4os6.getTramen(),
				vosalanos4os6.getTramat(), vosalanos4os6.getInfnue(),
				vosalanos4os6.getPlaaco(), vosalanos4os6.getNotas(),
				vosalanos4os6.getNmutua());
		return vosalanos4os6;
	}

	/**
	 * Updates a single row in the VosalanOs4Os6 table.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  VosalanOs4Os6
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @return the vosalan os 4 os 6
	 */
	public VosalanOs4Os6 update(VosalanOs4Os6 vosalanos4os6) {
		String query = "UPDATE VOSALAN_OS4_OS6 SET  WHERE TIPOOS=? AND CODCTR=? AND NUMDOC=? AND CODANO=? AND CODPRO=? AND NUMEJE=? AND FECVIS=? AND CODTEC=? AND OBSERV=? AND CODUSA=? AND FECUSA=? AND CODUSM=? AND FECUSM=? AND NUMEXP=? AND NOMPRO=? AND NOMCON=? AND AVIPRE=? AND COMAPE=? AND PLASEG=? AND NOMCOO=? AND EMPCON=? AND EMPSUB=? AND EMPAUT=? AND EMPNOM=? AND NOMRE1=? AND DESRE1=? AND NOMRE2=? AND DESRE2=? AND NOMRE3=? AND DESRE3=? AND NOMREP=? AND DESREP=? AND EMPPRO=? AND CCAU01=? AND CCAU02=? AND CCAU03=? AND CCAU04=? AND CCAU05=? AND CCAU06=? AND CCAU07=? AND CCAU08=? AND CCAU09=? AND CCAU10=? AND DIROBR=? AND FECREV=? AND NUMVIS=? AND NUECEN=? AND CODMOD=? AND MOPEMP=? AND FOREMP=? AND MOPTRA=? AND NUMTRA=? AND FORTRA=? AND NUMTRF=? AND MOPSPP=? AND SEGSPP=? AND HIGSPP=? AND ERGSPP=? AND MEDSPP=? AND MOPSPA=? AND NOMSPA=? AND SEGSPA=? AND HIGSPA=? AND ERGSPA=? AND MEDSPA=? AND COMSYS=? AND NUMCOE=? AND NUMCOT=? AND DELPRE=? AND NUMDEL=? AND FORDEL=? AND NUMDEF=? AND CODMER=? AND INDRER=? AND REREMO=? AND RERTRA=? AND RERSPP=? AND RERSPA=? AND REROTR=? AND DEROTR=? AND FIRMER=? AND PARDEL=? AND PARTRA=? AND CONDEL=? AND TRAINF=? AND MEDPLA=? AND MEDRES=? AND MEDFEC=? AND MEDPRE=? AND CODMME=? AND MEPLAC=? AND CONTRA=? AND MESIMU=? AND RMEEMP=? AND RMETRA=? AND RMESPP=? AND RMESPA=? AND RMEOTR=? AND DMEOTR=? AND FORTRP=? AND VIGSAL=? AND TRASEN=? AND TRAMEN=? AND TRAMAT=? AND INFNUE=? AND PLAACO=? AND NOTAS=? AND NMUTUA=?";
		this.jdbcTemplate.update(query, vosalanos4os6.getTipoos(),
				vosalanos4os6.getCodctr(), vosalanos4os6.getNumdoc(),
				vosalanos4os6.getCodano(), vosalanos4os6.getCodpro(),
				vosalanos4os6.getNumeje(), vosalanos4os6.getFecvis(),
				vosalanos4os6.getCodtec(), vosalanos4os6.getObserv(),
				vosalanos4os6.getCodusa(), vosalanos4os6.getFecusa(),
				vosalanos4os6.getCodusm(), vosalanos4os6.getFecusm(),
				vosalanos4os6.getNumexp(), vosalanos4os6.getNompro(),
				vosalanos4os6.getNomcon(), vosalanos4os6.getAvipre(),
				vosalanos4os6.getComape(), vosalanos4os6.getPlaseg(),
				vosalanos4os6.getNomcoo(), vosalanos4os6.getEmpcon(),
				vosalanos4os6.getEmpsub(), vosalanos4os6.getEmpaut(),
				vosalanos4os6.getEmpnom(), vosalanos4os6.getNomre1(),
				vosalanos4os6.getDesre1(), vosalanos4os6.getNomre2(),
				vosalanos4os6.getDesre2(), vosalanos4os6.getNomre3(),
				vosalanos4os6.getDesre3(), vosalanos4os6.getNomrep(),
				vosalanos4os6.getDesrep(), vosalanos4os6.getEmppro(),
				vosalanos4os6.getCcau01(), vosalanos4os6.getCcau02(),
				vosalanos4os6.getCcau03(), vosalanos4os6.getCcau04(),
				vosalanos4os6.getCcau05(), vosalanos4os6.getCcau06(),
				vosalanos4os6.getCcau07(), vosalanos4os6.getCcau08(),
				vosalanos4os6.getCcau09(), vosalanos4os6.getCcau10(),
				vosalanos4os6.getDirobr(), vosalanos4os6.getFecrev(),
				vosalanos4os6.getNumvis(), vosalanos4os6.getNuecen(),
				vosalanos4os6.getCodmod(), vosalanos4os6.getMopemp(),
				vosalanos4os6.getForemp(), vosalanos4os6.getMoptra(),
				vosalanos4os6.getNumtra(), vosalanos4os6.getFortra(),
				vosalanos4os6.getNumtrf(), vosalanos4os6.getMopspp(),
				vosalanos4os6.getSegspp(), vosalanos4os6.getHigspp(),
				vosalanos4os6.getErgspp(), vosalanos4os6.getMedspp(),
				vosalanos4os6.getMopspa(), vosalanos4os6.getNomspa(),
				vosalanos4os6.getSegspa(), vosalanos4os6.getHigspa(),
				vosalanos4os6.getErgspa(), vosalanos4os6.getMedspa(),
				vosalanos4os6.getComsys(), vosalanos4os6.getNumcoe(),
				vosalanos4os6.getNumcot(), vosalanos4os6.getDelpre(),
				vosalanos4os6.getNumdel(), vosalanos4os6.getFordel(),
				vosalanos4os6.getNumdef(), vosalanos4os6.getCodmer(),
				vosalanos4os6.getIndrer(), vosalanos4os6.getReremo(),
				vosalanos4os6.getRertra(), vosalanos4os6.getRerspp(),
				vosalanos4os6.getRerspa(), vosalanos4os6.getRerotr(),
				vosalanos4os6.getDerotr(), vosalanos4os6.getFirmer(),
				vosalanos4os6.getPardel(), vosalanos4os6.getPartra(),
				vosalanos4os6.getCondel(), vosalanos4os6.getTrainf(),
				vosalanos4os6.getMedpla(), vosalanos4os6.getMedres(),
				vosalanos4os6.getMedfec(), vosalanos4os6.getMedpre(),
				vosalanos4os6.getCodmme(), vosalanos4os6.getMeplac(),
				vosalanos4os6.getContra(), vosalanos4os6.getMesimu(),
				vosalanos4os6.getRmeemp(), vosalanos4os6.getRmetra(),
				vosalanos4os6.getRmespp(), vosalanos4os6.getRmespa(),
				vosalanos4os6.getRmeotr(), vosalanos4os6.getDmeotr(),
				vosalanos4os6.getFortrp(), vosalanos4os6.getVigsal(),
				vosalanos4os6.getTrasen(), vosalanos4os6.getTramen(),
				vosalanos4os6.getTramat(), vosalanos4os6.getInfnue(),
				vosalanos4os6.getPlaaco(), vosalanos4os6.getNotas(),
				vosalanos4os6.getNmutua());
		return vosalanos4os6;
	}

	/**
	 * Finds a single row in the VosalanOs4Os6 table.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  VosalanOs4Os6
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @return the vosalan os 4 os 6
	 */
	@Transactional(readOnly = true)
	public VosalanOs4Os6 find(VosalanOs4Os6 vosalanos4os6) {
		String query = "SELECT t1.TIPOOS TIPOOS, t1.CODCTR CODCTR, t1.NUMDOC NUMDOC, t1.CODANO CODANO, t1.CODPRO CODPRO, t1.NUMEJE NUMEJE, t1.FECVIS FECVIS, t1.CODTEC CODTEC, t1.OBSERV OBSERV, t1.CODUSA CODUSA, t1.FECUSA FECUSA, t1.CODUSM CODUSM, t1.FECUSM FECUSM, t1.NUMEXP NUMEXP, t1.NOMPRO NOMPRO, t1.NOMCON NOMCON, t1.AVIPRE AVIPRE, t1.COMAPE COMAPE, t1.PLASEG PLASEG, t1.NOMCOO NOMCOO, t1.EMPCON EMPCON, t1.EMPSUB EMPSUB, t1.EMPAUT EMPAUT, t1.EMPNOM EMPNOM, t1.NOMRE1 NOMRE1, t1.DESRE1 DESRE1, t1.NOMRE2 NOMRE2, t1.DESRE2 DESRE2, t1.NOMRE3 NOMRE3, t1.DESRE3 DESRE3, t1.NOMREP NOMREP, t1.DESREP DESREP, t1.EMPPRO EMPPRO, t1.CCAU01 CCAU01, t1.CCAU02 CCAU02, t1.CCAU03 CCAU03, t1.CCAU04 CCAU04, t1.CCAU05 CCAU05, t1.CCAU06 CCAU06, t1.CCAU07 CCAU07, t1.CCAU08 CCAU08, t1.CCAU09 CCAU09, t1.CCAU10 CCAU10, t1.DIROBR DIROBR, t1.FECREV FECREV, t1.NUMVIS NUMVIS, t1.NUECEN NUECEN, t1.CODMOD CODMOD, t1.MOPEMP MOPEMP, t1.FOREMP FOREMP, t1.MOPTRA MOPTRA, t1.NUMTRA NUMTRA, t1.FORTRA FORTRA, t1.NUMTRF NUMTRF, t1.MOPSPP MOPSPP, t1.SEGSPP SEGSPP, t1.HIGSPP HIGSPP, t1.ERGSPP ERGSPP, t1.MEDSPP MEDSPP, t1.MOPSPA MOPSPA, t1.NOMSPA NOMSPA, t1.SEGSPA SEGSPA, t1.HIGSPA HIGSPA, t1.ERGSPA ERGSPA, t1.MEDSPA MEDSPA, t1.COMSYS COMSYS, t1.NUMCOE NUMCOE, t1.NUMCOT NUMCOT, t1.DELPRE DELPRE, t1.NUMDEL NUMDEL, t1.FORDEL FORDEL, t1.NUMDEF NUMDEF, t1.CODMER CODMER, t1.INDRER INDRER, t1.REREMO REREMO, t1.RERTRA RERTRA, t1.RERSPP RERSPP, t1.RERSPA RERSPA, t1.REROTR REROTR, t1.DEROTR DEROTR, t1.FIRMER FIRMER, t1.PARDEL PARDEL, t1.PARTRA PARTRA, t1.CONDEL CONDEL, t1.TRAINF TRAINF, t1.MEDPLA MEDPLA, t1.MEDRES MEDRES, t1.MEDFEC MEDFEC, t1.MEDPRE MEDPRE, t1.CODMME CODMME, t1.MEPLAC MEPLAC, t1.CONTRA CONTRA, t1.MESIMU MESIMU, t1.RMEEMP RMEEMP, t1.RMETRA RMETRA, t1.RMESPP RMESPP, t1.RMESPA RMESPA, t1.RMEOTR RMEOTR, t1.DMEOTR DMEOTR, t1.FORTRP FORTRP, t1.VIGSAL VIGSAL, t1.TRASEN TRASEN, t1.TRAMEN TRAMEN, t1.TRAMAT TRAMAT, t1.INFNUE INFNUE, t1.PLAACO PLAACO, t1.NOTAS NOTAS, t1.NMUTUA NMUTUA FROM VOSALAN_OS4_OS6 t1  WHERE t1.TIPOOS = ?   AND t1.CODCTR = ?   AND t1.NUMDOC = ?   AND t1.CODANO = ?   AND t1.CODPRO = ?   AND t1.NUMEJE = ?   AND t1.FECVIS = ?   AND t1.CODTEC = ?   AND t1.NUMEXP = ? ";

		List<VosalanOs4Os6> vosalanos4os6List = this.jdbcTemplate.query(query,
				this.rwMap, vosalanos4os6.getTipoos(),
				vosalanos4os6.getCodctr(), vosalanos4os6.getNumdoc(),
				vosalanos4os6.getCodano(), vosalanos4os6.getCodpro(),
				vosalanos4os6.getNumeje(), vosalanos4os6.getFecvis(),
				vosalanos4os6.getCodtec(), vosalanos4os6.getNumexp());
		return (VosalanOs4Os6) DataAccessUtils.uniqueResult(vosalanos4os6List);
	}

	/**
	 * Removes a single row in the VosalanOs4Os6 table.
	 * 
	 *  vosalanos4os6            VosalanOs4Os6
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 */
	public void remove(VosalanOs4Os6 vosalanos4os6) {
		String query = "DELETE FROM VOSALAN_OS4_OS6 WHERE TIPOOS=? AND CODCTR=? AND NUMDOC=? AND CODANO=? AND CODPRO=? AND NUMEJE=? AND FECVIS=? AND CODTEC=? AND OBSERV=? AND CODUSA=? AND FECUSA=? AND CODUSM=? AND FECUSM=? AND NUMEXP=? AND NOMPRO=? AND NOMCON=? AND AVIPRE=? AND COMAPE=? AND PLASEG=? AND NOMCOO=? AND EMPCON=? AND EMPSUB=? AND EMPAUT=? AND EMPNOM=? AND NOMRE1=? AND DESRE1=? AND NOMRE2=? AND DESRE2=? AND NOMRE3=? AND DESRE3=? AND NOMREP=? AND DESREP=? AND EMPPRO=? AND CCAU01=? AND CCAU02=? AND CCAU03=? AND CCAU04=? AND CCAU05=? AND CCAU06=? AND CCAU07=? AND CCAU08=? AND CCAU09=? AND CCAU10=? AND DIROBR=? AND FECREV=? AND NUMVIS=? AND NUECEN=? AND CODMOD=? AND MOPEMP=? AND FOREMP=? AND MOPTRA=? AND NUMTRA=? AND FORTRA=? AND NUMTRF=? AND MOPSPP=? AND SEGSPP=? AND HIGSPP=? AND ERGSPP=? AND MEDSPP=? AND MOPSPA=? AND NOMSPA=? AND SEGSPA=? AND HIGSPA=? AND ERGSPA=? AND MEDSPA=? AND COMSYS=? AND NUMCOE=? AND NUMCOT=? AND DELPRE=? AND NUMDEL=? AND FORDEL=? AND NUMDEF=? AND CODMER=? AND INDRER=? AND REREMO=? AND RERTRA=? AND RERSPP=? AND RERSPA=? AND REROTR=? AND DEROTR=? AND FIRMER=? AND PARDEL=? AND PARTRA=? AND CONDEL=? AND TRAINF=? AND MEDPLA=? AND MEDRES=? AND MEDFEC=? AND MEDPRE=? AND CODMME=? AND MEPLAC=? AND CONTRA=? AND MESIMU=? AND RMEEMP=? AND RMETRA=? AND RMESPP=? AND RMESPA=? AND RMEOTR=? AND DMEOTR=? AND FORTRP=? AND VIGSAL=? AND TRASEN=? AND TRAMEN=? AND TRAMAT=? AND INFNUE=? AND PLAACO=? AND NOTAS=? AND NMUTUA=?";
		this.jdbcTemplate.update(query, vosalanos4os6.getTipoos(),
				vosalanos4os6.getCodctr(), vosalanos4os6.getNumdoc(),
				vosalanos4os6.getCodano(), vosalanos4os6.getCodpro(),
				vosalanos4os6.getNumeje(), vosalanos4os6.getFecvis(),
				vosalanos4os6.getCodtec(), vosalanos4os6.getObserv(),
				vosalanos4os6.getCodusa(), vosalanos4os6.getFecusa(),
				vosalanos4os6.getCodusm(), vosalanos4os6.getFecusm(),
				vosalanos4os6.getNumexp(), vosalanos4os6.getNompro(),
				vosalanos4os6.getNomcon(), vosalanos4os6.getAvipre(),
				vosalanos4os6.getComape(), vosalanos4os6.getPlaseg(),
				vosalanos4os6.getNomcoo(), vosalanos4os6.getEmpcon(),
				vosalanos4os6.getEmpsub(), vosalanos4os6.getEmpaut(),
				vosalanos4os6.getEmpnom(), vosalanos4os6.getNomre1(),
				vosalanos4os6.getDesre1(), vosalanos4os6.getNomre2(),
				vosalanos4os6.getDesre2(), vosalanos4os6.getNomre3(),
				vosalanos4os6.getDesre3(), vosalanos4os6.getNomrep(),
				vosalanos4os6.getDesrep(), vosalanos4os6.getEmppro(),
				vosalanos4os6.getCcau01(), vosalanos4os6.getCcau02(),
				vosalanos4os6.getCcau03(), vosalanos4os6.getCcau04(),
				vosalanos4os6.getCcau05(), vosalanos4os6.getCcau06(),
				vosalanos4os6.getCcau07(), vosalanos4os6.getCcau08(),
				vosalanos4os6.getCcau09(), vosalanos4os6.getCcau10(),
				vosalanos4os6.getDirobr(), vosalanos4os6.getFecrev(),
				vosalanos4os6.getNumvis(), vosalanos4os6.getNuecen(),
				vosalanos4os6.getCodmod(), vosalanos4os6.getMopemp(),
				vosalanos4os6.getForemp(), vosalanos4os6.getMoptra(),
				vosalanos4os6.getNumtra(), vosalanos4os6.getFortra(),
				vosalanos4os6.getNumtrf(), vosalanos4os6.getMopspp(),
				vosalanos4os6.getSegspp(), vosalanos4os6.getHigspp(),
				vosalanos4os6.getErgspp(), vosalanos4os6.getMedspp(),
				vosalanos4os6.getMopspa(), vosalanos4os6.getNomspa(),
				vosalanos4os6.getSegspa(), vosalanos4os6.getHigspa(),
				vosalanos4os6.getErgspa(), vosalanos4os6.getMedspa(),
				vosalanos4os6.getComsys(), vosalanos4os6.getNumcoe(),
				vosalanos4os6.getNumcot(), vosalanos4os6.getDelpre(),
				vosalanos4os6.getNumdel(), vosalanos4os6.getFordel(),
				vosalanos4os6.getNumdef(), vosalanos4os6.getCodmer(),
				vosalanos4os6.getIndrer(), vosalanos4os6.getReremo(),
				vosalanos4os6.getRertra(), vosalanos4os6.getRerspp(),
				vosalanos4os6.getRerspa(), vosalanos4os6.getRerotr(),
				vosalanos4os6.getDerotr(), vosalanos4os6.getFirmer(),
				vosalanos4os6.getPardel(), vosalanos4os6.getPartra(),
				vosalanos4os6.getCondel(), vosalanos4os6.getTrainf(),
				vosalanos4os6.getMedpla(), vosalanos4os6.getMedres(),
				vosalanos4os6.getMedfec(), vosalanos4os6.getMedpre(),
				vosalanos4os6.getCodmme(), vosalanos4os6.getMeplac(),
				vosalanos4os6.getContra(), vosalanos4os6.getMesimu(),
				vosalanos4os6.getRmeemp(), vosalanos4os6.getRmetra(),
				vosalanos4os6.getRmespp(), vosalanos4os6.getRmespa(),
				vosalanos4os6.getRmeotr(), vosalanos4os6.getDmeotr(),
				vosalanos4os6.getFortrp(), vosalanos4os6.getVigsal(),
				vosalanos4os6.getTrasen(), vosalanos4os6.getTramen(),
				vosalanos4os6.getTramat(), vosalanos4os6.getInfnue(),
				vosalanos4os6.getPlaaco(), vosalanos4os6.getNotas(),
				vosalanos4os6.getNmutua());
	}

	/**
	 * Finds a list of rows in the VosalanOs4Os6 table.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VosalanOs4Os6>
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VosalanOs4Os6> findAll(VosalanOs4Os6 vosalanos4os6,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TIPOOS TIPOOS,t1.CODCTR CODCTR,t1.NUMDOC NUMDOC,t1.CODANO CODANO,t1.CODPRO CODPRO,t1.NUMEJE NUMEJE,t1.FECVIS FECVIS,t1.CODTEC CODTEC,t1.OBSERV OBSERV,t1.CODUSA CODUSA,t1.FECUSA FECUSA,t1.CODUSM CODUSM,t1.FECUSM FECUSM,t1.NUMEXP NUMEXP,t1.NOMPRO NOMPRO,t1.NOMCON NOMCON,t1.AVIPRE AVIPRE,t1.COMAPE COMAPE,t1.PLASEG PLASEG,t1.NOMCOO NOMCOO,t1.EMPCON EMPCON,t1.EMPSUB EMPSUB,t1.EMPAUT EMPAUT,t1.EMPNOM EMPNOM,t1.NOMRE1 NOMRE1,t1.DESRE1 DESRE1,t1.NOMRE2 NOMRE2,t1.DESRE2 DESRE2,t1.NOMRE3 NOMRE3,t1.DESRE3 DESRE3,t1.NOMREP NOMREP,t1.DESREP DESREP,t1.EMPPRO EMPPRO,t1.CCAU01 CCAU01,t1.CCAU02 CCAU02,t1.CCAU03 CCAU03,t1.CCAU04 CCAU04,t1.CCAU05 CCAU05,t1.CCAU06 CCAU06,t1.CCAU07 CCAU07,t1.CCAU08 CCAU08,t1.CCAU09 CCAU09,t1.CCAU10 CCAU10,t1.DIROBR DIROBR,t1.FECREV FECREV,t1.NUMVIS NUMVIS,t1.NUECEN NUECEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMP FOREMP,t1.MOPTRA MOPTRA,t1.NUMTRA NUMTRA,t1.FORTRA FORTRA,t1.NUMTRF NUMTRF,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.NOMSPA NOMSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.COMSYS COMSYS,t1.NUMCOE NUMCOE,t1.NUMCOT NUMCOT,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORDEL FORDEL,t1.NUMDEF NUMDEF,t1.CODMER CODMER,t1.INDRER INDRER,t1.REREMO REREMO,t1.RERTRA RERTRA,t1.RERSPP RERSPP,t1.RERSPA RERSPA,t1.REROTR REROTR,t1.DEROTR DEROTR,t1.FIRMER FIRMER,t1.PARDEL PARDEL,t1.PARTRA PARTRA,t1.CONDEL CONDEL,t1.TRAINF TRAINF,t1.MEDPLA MEDPLA,t1.MEDRES MEDRES,t1.MEDFEC MEDFEC,t1.MEDPRE MEDPRE,t1.CODMME CODMME,t1.MEPLAC MEPLAC,t1.CONTRA CONTRA,t1.MESIMU MESIMU,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMESPA RMESPA,t1.RMEOTR RMEOTR,t1.DMEOTR DMEOTR,t1.FORTRP FORTRP,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUE INFNUE,t1.PLAACO PLAACO,t1.NOTAS NOTAS,t1.NMUTUA NMUTUA ");
		query.append("FROM VOSALAN_OS4_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vosalanos4os6);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VosalanOs4Os6>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VosalanOs4Os6 table using like.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VosalanOs4Os6>
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VosalanOs4Os6> findAllLike(VosalanOs4Os6 vosalanos4os6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.TIPOOS TIPOOS,t1.CODCTR CODCTR,t1.NUMDOC NUMDOC,t1.CODANO CODANO,t1.CODPRO CODPRO,t1.NUMEJE NUMEJE,t1.FECVIS FECVIS,t1.CODTEC CODTEC,t1.OBSERV OBSERV,t1.CODUSA CODUSA,t1.FECUSA FECUSA,t1.CODUSM CODUSM,t1.FECUSM FECUSM,t1.NUMEXP NUMEXP,t1.NOMPRO NOMPRO,t1.NOMCON NOMCON,t1.AVIPRE AVIPRE,t1.COMAPE COMAPE,t1.PLASEG PLASEG,t1.NOMCOO NOMCOO,t1.EMPCON EMPCON,t1.EMPSUB EMPSUB,t1.EMPAUT EMPAUT,t1.EMPNOM EMPNOM,t1.NOMRE1 NOMRE1,t1.DESRE1 DESRE1,t1.NOMRE2 NOMRE2,t1.DESRE2 DESRE2,t1.NOMRE3 NOMRE3,t1.DESRE3 DESRE3,t1.NOMREP NOMREP,t1.DESREP DESREP,t1.EMPPRO EMPPRO,t1.CCAU01 CCAU01,t1.CCAU02 CCAU02,t1.CCAU03 CCAU03,t1.CCAU04 CCAU04,t1.CCAU05 CCAU05,t1.CCAU06 CCAU06,t1.CCAU07 CCAU07,t1.CCAU08 CCAU08,t1.CCAU09 CCAU09,t1.CCAU10 CCAU10,t1.DIROBR DIROBR,t1.FECREV FECREV,t1.NUMVIS NUMVIS,t1.NUECEN NUECEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMP FOREMP,t1.MOPTRA MOPTRA,t1.NUMTRA NUMTRA,t1.FORTRA FORTRA,t1.NUMTRF NUMTRF,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.NOMSPA NOMSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.COMSYS COMSYS,t1.NUMCOE NUMCOE,t1.NUMCOT NUMCOT,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORDEL FORDEL,t1.NUMDEF NUMDEF,t1.CODMER CODMER,t1.INDRER INDRER,t1.REREMO REREMO,t1.RERTRA RERTRA,t1.RERSPP RERSPP,t1.RERSPA RERSPA,t1.REROTR REROTR,t1.DEROTR DEROTR,t1.FIRMER FIRMER,t1.PARDEL PARDEL,t1.PARTRA PARTRA,t1.CONDEL CONDEL,t1.TRAINF TRAINF,t1.MEDPLA MEDPLA,t1.MEDRES MEDRES,t1.MEDFEC MEDFEC,t1.MEDPRE MEDPRE,t1.CODMME CODMME,t1.MEPLAC MEPLAC,t1.CONTRA CONTRA,t1.MESIMU MESIMU,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMESPA RMESPA,t1.RMEOTR RMEOTR,t1.DMEOTR DMEOTR,t1.FORTRP FORTRP,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUE INFNUE,t1.PLAACO PLAACO,t1.NOTAS NOTAS,t1.NMUTUA NMUTUA ");
		query.append("FROM VOSALAN_OS4_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vosalanos4os6,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VosalanOs4Os6>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VosalanOs4Os6 table.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  Long
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VosalanOs4Os6 vosalanos4os6) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VOSALAN_OS4_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vosalanos4os6);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VosalanOs4Os6 table using like.
	 * 
	 *  vosalanos4os6
	 *            VosalanOs4Os6
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VosalanOs4Os6 vosalanos4os6,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VOSALAN_OS4_OS6 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vosalanos4os6,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VosalanOs4Os6 selected for rup_table.
	 * 
	 *  vosalanos4os6            VosalanOs4Os6
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VosalanOs4Os6>>
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VosalanOs4Os6>> reorderSelection(
			VosalanOs4Os6 vosalanos4os6, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.CODCTR CODCTR,t1.NUMDOC NUMDOC,t1.CODANO CODANO,t1.CODPRO CODPRO,t1.NUMEJE NUMEJE,t1.FECVIS FECVIS,t1.CODTEC CODTEC,t1.OBSERV OBSERV,t1.CODUSA CODUSA,t1.FECUSA FECUSA,t1.CODUSM CODUSM,t1.FECUSM FECUSM,t1.NUMEXP NUMEXP,t1.NOMPRO NOMPRO,t1.NOMCON NOMCON,t1.AVIPRE AVIPRE,t1.COMAPE COMAPE,t1.PLASEG PLASEG,t1.NOMCOO NOMCOO,t1.EMPCON EMPCON,t1.EMPSUB EMPSUB,t1.EMPAUT EMPAUT,t1.EMPNOM EMPNOM,t1.NOMRE1 NOMRE1,t1.DESRE1 DESRE1,t1.NOMRE2 NOMRE2,t1.DESRE2 DESRE2,t1.NOMRE3 NOMRE3,t1.DESRE3 DESRE3,t1.NOMREP NOMREP,t1.DESREP DESREP,t1.EMPPRO EMPPRO,t1.CCAU01 CCAU01,t1.CCAU02 CCAU02,t1.CCAU03 CCAU03,t1.CCAU04 CCAU04,t1.CCAU05 CCAU05,t1.CCAU06 CCAU06,t1.CCAU07 CCAU07,t1.CCAU08 CCAU08,t1.CCAU09 CCAU09,t1.CCAU10 CCAU10,t1.DIROBR DIROBR,t1.FECREV FECREV,t1.NUMVIS NUMVIS,t1.NUECEN NUECEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMP FOREMP,t1.MOPTRA MOPTRA,t1.NUMTRA NUMTRA,t1.FORTRA FORTRA,t1.NUMTRF NUMTRF,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.NOMSPA NOMSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.COMSYS COMSYS,t1.NUMCOE NUMCOE,t1.NUMCOT NUMCOT,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORDEL FORDEL,t1.NUMDEF NUMDEF,t1.CODMER CODMER,t1.INDRER INDRER,t1.REREMO REREMO,t1.RERTRA RERTRA,t1.RERSPP RERSPP,t1.RERSPA RERSPA,t1.REROTR REROTR,t1.DEROTR DEROTR,t1.FIRMER FIRMER,t1.PARDEL PARDEL,t1.PARTRA PARTRA,t1.CONDEL CONDEL,t1.TRAINF TRAINF,t1.MEDPLA MEDPLA,t1.MEDRES MEDRES,t1.MEDFEC MEDFEC,t1.MEDPRE MEDPRE,t1.CODMME CODMME,t1.MEPLAC MEPLAC,t1.CONTRA CONTRA,t1.MESIMU MESIMU,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMESPA RMESPA,t1.RMEOTR RMEOTR,t1.DMEOTR DMEOTR,t1.FORTRP FORTRP,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUE INFNUE,t1.PLAACO PLAACO,t1.NOTAS NOTAS,t1.NMUTUA NMUTUA ");
		// FROM
		query.append("FROM VOSALAN_OS4_OS6 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vosalanos4os6,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, VosalanOs4Os6.class, filterParamList,
				"TIPOOS,CODCTR,NUMDOC,CODANO,CODPRO,NUMEJE,FECVIS,CODTEC,OBSERV,CODUSA,FECUSA,CODUSM,FECUSM,NUMEXP,NOMPRO,NOMCON,AVIPRE,COMAPE,PLASEG,NOMCOO,EMPCON,EMPSUB,EMPAUT,EMPNOM,NOMRE1,DESRE1,NOMRE2,DESRE2,NOMRE3,DESRE3,NOMREP,DESREP,EMPPRO,CCAU01,CCAU02,CCAU03,CCAU04,CCAU05,CCAU06,CCAU07,CCAU08,CCAU09,CCAU10,DIROBR,FECREV,NUMVIS,NUECEN,CODMOD,MOPEMP,FOREMP,MOPTRA,NUMTRA,FORTRA,NUMTRF,MOPSPP,SEGSPP,HIGSPP,ERGSPP,MEDSPP,MOPSPA,NOMSPA,SEGSPA,HIGSPA,ERGSPA,MEDSPA,COMSYS,NUMCOE,NUMCOT,DELPRE,NUMDEL,FORDEL,NUMDEF,CODMER,INDRER,REREMO,RERTRA,RERSPP,RERSPA,REROTR,DEROTR,FIRMER,PARDEL,PARTRA,CONDEL,TRAINF,MEDPLA,MEDRES,MEDFEC,MEDPRE,CODMME,MEPLAC,CONTRA,MESIMU,RMEEMP,RMETRA,RMESPP,RMESPA,RMEOTR,DMEOTR,FORTRP,VIGSAL,TRASEN,TRAMEN,TRAMAT,INFNUE,PLAACO,NOTAS,NMUTUA");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VosalanOs4Os6>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VosalanOs4Os6
	 *  searchParams            VosalanOs4Os6
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VosalanOs4Os6>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VosalanOs4Os6>> search(VosalanOs4Os6 filterParams,
			VosalanOs4Os6 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.CODCTR CODCTR,t1.NUMDOC NUMDOC,t1.CODANO CODANO,t1.CODPRO CODPRO,t1.NUMEJE NUMEJE,t1.FECVIS FECVIS,t1.CODTEC CODTEC,t1.OBSERV OBSERV,t1.CODUSA CODUSA,t1.FECUSA FECUSA,t1.CODUSM CODUSM,t1.FECUSM FECUSM,t1.NUMEXP NUMEXP,t1.NOMPRO NOMPRO,t1.NOMCON NOMCON,t1.AVIPRE AVIPRE,t1.COMAPE COMAPE,t1.PLASEG PLASEG,t1.NOMCOO NOMCOO,t1.EMPCON EMPCON,t1.EMPSUB EMPSUB,t1.EMPAUT EMPAUT,t1.EMPNOM EMPNOM,t1.NOMRE1 NOMRE1,t1.DESRE1 DESRE1,t1.NOMRE2 NOMRE2,t1.DESRE2 DESRE2,t1.NOMRE3 NOMRE3,t1.DESRE3 DESRE3,t1.NOMREP NOMREP,t1.DESREP DESREP,t1.EMPPRO EMPPRO,t1.CCAU01 CCAU01,t1.CCAU02 CCAU02,t1.CCAU03 CCAU03,t1.CCAU04 CCAU04,t1.CCAU05 CCAU05,t1.CCAU06 CCAU06,t1.CCAU07 CCAU07,t1.CCAU08 CCAU08,t1.CCAU09 CCAU09,t1.CCAU10 CCAU10,t1.DIROBR DIROBR,t1.FECREV FECREV,t1.NUMVIS NUMVIS,t1.NUECEN NUECEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMP FOREMP,t1.MOPTRA MOPTRA,t1.NUMTRA NUMTRA,t1.FORTRA FORTRA,t1.NUMTRF NUMTRF,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.NOMSPA NOMSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.COMSYS COMSYS,t1.NUMCOE NUMCOE,t1.NUMCOT NUMCOT,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORDEL FORDEL,t1.NUMDEF NUMDEF,t1.CODMER CODMER,t1.INDRER INDRER,t1.REREMO REREMO,t1.RERTRA RERTRA,t1.RERSPP RERSPP,t1.RERSPA RERSPA,t1.REROTR REROTR,t1.DEROTR DEROTR,t1.FIRMER FIRMER,t1.PARDEL PARDEL,t1.PARTRA PARTRA,t1.CONDEL CONDEL,t1.TRAINF TRAINF,t1.MEDPLA MEDPLA,t1.MEDRES MEDRES,t1.MEDFEC MEDFEC,t1.MEDPRE MEDPRE,t1.CODMME CODMME,t1.MEPLAC MEPLAC,t1.CONTRA CONTRA,t1.MESIMU MESIMU,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMESPA RMESPA,t1.RMEOTR RMEOTR,t1.DMEOTR DMEOTR,t1.FORTRP FORTRP,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUE INFNUE,t1.PLAACO PLAACO,t1.NOTAS NOTAS,t1.NMUTUA NMUTUA ");
		// FROM
		query.append("FROM VOSALAN_OS4_OS6 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, VosalanOs4Os6.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"TIPOOS,CODCTR,NUMDOC,CODANO,CODPRO,NUMEJE,FECVIS,CODTEC,OBSERV,CODUSA,FECUSA,CODUSM,FECUSM,NUMEXP,NOMPRO,NOMCON,AVIPRE,COMAPE,PLASEG,NOMCOO,EMPCON,EMPSUB,EMPAUT,EMPNOM,NOMRE1,DESRE1,NOMRE2,DESRE2,NOMRE3,DESRE3,NOMREP,DESREP,EMPPRO,CCAU01,CCAU02,CCAU03,CCAU04,CCAU05,CCAU06,CCAU07,CCAU08,CCAU09,CCAU10,DIROBR,FECREV,NUMVIS,NUECEN,CODMOD,MOPEMP,FOREMP,MOPTRA,NUMTRA,FORTRA,NUMTRF,MOPSPP,SEGSPP,HIGSPP,ERGSPP,MEDSPP,MOPSPA,NOMSPA,SEGSPA,HIGSPA,ERGSPA,MEDSPA,COMSYS,NUMCOE,NUMCOT,DELPRE,NUMDEL,FORDEL,NUMDEF,CODMER,INDRER,REREMO,RERTRA,RERSPP,RERSPA,REROTR,DEROTR,FIRMER,PARDEL,PARTRA,CONDEL,TRAINF,MEDPLA,MEDRES,MEDFEC,MEDPRE,CODMME,MEPLAC,CONTRA,MESIMU,RMEEMP,RMETRA,RMESPP,RMESPA,RMEOTR,DMEOTR,FORTRP,VIGSAL,TRASEN,TRAMEN,TRAMAT,INFNUE,PLAACO,NOTAS,NMUTUA");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<VosalanOs4Os6>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervosalanos4os6            VosalanOs4Os6
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervosalanos4os6 the filtervosalanos 4 os 6
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VosalanOs4Os6 filtervosalanos4os6,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.TIPOOS TIPOOS,t1.CODCTR CODCTR,t1.NUMDOC NUMDOC,t1.CODANO CODANO,t1.CODPRO CODPRO,t1.NUMEJE NUMEJE,t1.FECVIS FECVIS,t1.CODTEC CODTEC,t1.OBSERV OBSERV,t1.CODUSA CODUSA,t1.FECUSA FECUSA,t1.CODUSM CODUSM,t1.FECUSM FECUSM,t1.NUMEXP NUMEXP,t1.NOMPRO NOMPRO,t1.NOMCON NOMCON,t1.AVIPRE AVIPRE,t1.COMAPE COMAPE,t1.PLASEG PLASEG,t1.NOMCOO NOMCOO,t1.EMPCON EMPCON,t1.EMPSUB EMPSUB,t1.EMPAUT EMPAUT,t1.EMPNOM EMPNOM,t1.NOMRE1 NOMRE1,t1.DESRE1 DESRE1,t1.NOMRE2 NOMRE2,t1.DESRE2 DESRE2,t1.NOMRE3 NOMRE3,t1.DESRE3 DESRE3,t1.NOMREP NOMREP,t1.DESREP DESREP,t1.EMPPRO EMPPRO,t1.CCAU01 CCAU01,t1.CCAU02 CCAU02,t1.CCAU03 CCAU03,t1.CCAU04 CCAU04,t1.CCAU05 CCAU05,t1.CCAU06 CCAU06,t1.CCAU07 CCAU07,t1.CCAU08 CCAU08,t1.CCAU09 CCAU09,t1.CCAU10 CCAU10,t1.DIROBR DIROBR,t1.FECREV FECREV,t1.NUMVIS NUMVIS,t1.NUECEN NUECEN,t1.CODMOD CODMOD,t1.MOPEMP MOPEMP,t1.FOREMP FOREMP,t1.MOPTRA MOPTRA,t1.NUMTRA NUMTRA,t1.FORTRA FORTRA,t1.NUMTRF NUMTRF,t1.MOPSPP MOPSPP,t1.SEGSPP SEGSPP,t1.HIGSPP HIGSPP,t1.ERGSPP ERGSPP,t1.MEDSPP MEDSPP,t1.MOPSPA MOPSPA,t1.NOMSPA NOMSPA,t1.SEGSPA SEGSPA,t1.HIGSPA HIGSPA,t1.ERGSPA ERGSPA,t1.MEDSPA MEDSPA,t1.COMSYS COMSYS,t1.NUMCOE NUMCOE,t1.NUMCOT NUMCOT,t1.DELPRE DELPRE,t1.NUMDEL NUMDEL,t1.FORDEL FORDEL,t1.NUMDEF NUMDEF,t1.CODMER CODMER,t1.INDRER INDRER,t1.REREMO REREMO,t1.RERTRA RERTRA,t1.RERSPP RERSPP,t1.RERSPA RERSPA,t1.REROTR REROTR,t1.DEROTR DEROTR,t1.FIRMER FIRMER,t1.PARDEL PARDEL,t1.PARTRA PARTRA,t1.CONDEL CONDEL,t1.TRAINF TRAINF,t1.MEDPLA MEDPLA,t1.MEDRES MEDRES,t1.MEDFEC MEDFEC,t1.MEDPRE MEDPRE,t1.CODMME CODMME,t1.MEPLAC MEPLAC,t1.CONTRA CONTRA,t1.MESIMU MESIMU,t1.RMEEMP RMEEMP,t1.RMETRA RMETRA,t1.RMESPP RMESPP,t1.RMESPA RMESPA,t1.RMEOTR RMEOTR,t1.DMEOTR DMEOTR,t1.FORTRP FORTRP,t1.VIGSAL VIGSAL,t1.TRASEN TRASEN,t1.TRAMEN TRAMEN,t1.TRAMAT TRAMAT,t1.INFNUE INFNUE,t1.PLAACO PLAACO,t1.NOTAS NOTAS,t1.NMUTUA NMUTUA ");
		// FROM
		query.append("FROM VOSALAN_OS4_OS6 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this
				.getWhereLikeMap(filtervosalanos4os6, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, VosalanOs4Os6.class,
						query, params,
						"TIPOOS,CODCTR,NUMDOC,CODANO,CODPRO,NUMEJE,FECVIS,CODTEC,OBSERV,CODUSA,FECUSA,CODUSM,FECUSM,NUMEXP,NOMPRO,NOMCON,AVIPRE,COMAPE,PLASEG,NOMCOO,EMPCON,EMPSUB,EMPAUT,EMPNOM,NOMRE1,DESRE1,NOMRE2,DESRE2,NOMRE3,DESRE3,NOMREP,DESREP,EMPPRO,CCAU01,CCAU02,CCAU03,CCAU04,CCAU05,CCAU06,CCAU07,CCAU08,CCAU09,CCAU10,DIROBR,FECREV,NUMVIS,NUECEN,CODMOD,MOPEMP,FOREMP,MOPTRA,NUMTRA,FORTRA,NUMTRF,MOPSPP,SEGSPP,HIGSPP,ERGSPP,MEDSPP,MOPSPA,NOMSPA,SEGSPA,HIGSPA,ERGSPA,MEDSPA,COMSYS,NUMCOE,NUMCOT,DELPRE,NUMDEL,FORDEL,NUMDEF,CODMER,INDRER,REREMO,RERTRA,RERSPP,RERSPA,REROTR,DEROTR,FIRMER,PARDEL,PARTRA,CONDEL,TRAINF,MEDPLA,MEDRES,MEDFEC,MEDPRE,CODMME,MEPLAC,CONTRA,MESIMU,RMEEMP,RMETRA,RMESPP,RMESPA,RMEOTR,DMEOTR,FORTRP,VIGSAL,TRASEN,TRAMEN,TRAMAT,INFNUE,PLAACO,NOTAS,NMUTUA");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VosalanOs4Os6 entity.
	 * 
	 *  vosalanos4os6            VosalanOs4Os6 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VosalanOs4Os6 vosalanos4os6) {

		StringBuilder where = new StringBuilder(
				VosalanOs4Os6DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		String mascara = Utilities.getInstance().getDateMask();

		if (vosalanos4os6 != null && vosalanos4os6.getTipoos() != null) {
			where.append(" AND t1.TIPOOS = ?");
			params.add(vosalanos4os6.getTipoos());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodctr() != null) {
			where.append(" AND t1.CODCTR = ?");
			params.add(vosalanos4os6.getCodctr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumdoc() != null) {
			where.append(" AND t1.NUMDOC = ?");
			params.add(vosalanos4os6.getNumdoc());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodano() != null) {
			where.append(" AND t1.CODANO = ?");
			params.add(vosalanos4os6.getCodano());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodpro() != null) {
			where.append(" AND t1.CODPRO = ?");
			params.add(vosalanos4os6.getCodpro());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumeje() != null) {
			where.append(" AND t1.NUMEJE = ?");
			params.add(vosalanos4os6.getNumeje());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecvis() != null) {
			where.append(" AND t1.FECVIS = ?");
			params.add(vosalanos4os6.getFecvis());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecvisDesde() != null) {
			where.append(" AND TRUNC(t1.FECVIS) >= trunc(to_date(?, ?)) ");
			params.add(vosalanos4os6.getFecvisDesdeStr());
			params.add(mascara);
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecvisHasta() != null) {
			where.append(" AND TRUNC(t1.FECVIS) <= trunc(to_date(?, ?)) ");
			params.add(vosalanos4os6.getFecvisHastaStr());
			params.add(mascara);
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodtec() != null) {
			where.append(" AND t1.CODTEC = ?");
			params.add(vosalanos4os6.getCodtec());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getObserv() != null) {
			where.append(" AND t1.OBSERV = ?");
			params.add(vosalanos4os6.getObserv());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodusa() != null) {
			where.append(" AND t1.CODUSA = ?");
			params.add(vosalanos4os6.getCodusa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecusa() != null) {
			where.append(" AND t1.FECUSA = ?");
			params.add(vosalanos4os6.getFecusa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodusm() != null) {
			where.append(" AND t1.CODUSM = ?");
			params.add(vosalanos4os6.getCodusm());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecusm() != null) {
			where.append(" AND t1.FECUSM = ?");
			params.add(vosalanos4os6.getFecusm());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(vosalanos4os6.getNumexp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNompro() != null) {
			where.append(" AND t1.NOMPRO = ?");
			params.add(vosalanos4os6.getNompro());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomcon() != null) {
			where.append(" AND t1.NOMCON = ?");
			params.add(vosalanos4os6.getNomcon());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getAvipre() != null) {
			where.append(" AND t1.AVIPRE = ?");
			params.add(vosalanos4os6.getAvipre());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getComape() != null) {
			where.append(" AND t1.COMAPE = ?");
			params.add(vosalanos4os6.getComape());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPlaseg() != null) {
			where.append(" AND t1.PLASEG = ?");
			params.add(vosalanos4os6.getPlaseg());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomcoo() != null) {
			where.append(" AND t1.NOMCOO = ?");
			params.add(vosalanos4os6.getNomcoo());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpcon() != null) {
			where.append(" AND t1.EMPCON = ?");
			params.add(vosalanos4os6.getEmpcon());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpsub() != null) {
			where.append(" AND t1.EMPSUB = ?");
			params.add(vosalanos4os6.getEmpsub());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpaut() != null) {
			where.append(" AND t1.EMPAUT = ?");
			params.add(vosalanos4os6.getEmpaut());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpnom() != null) {
			where.append(" AND t1.EMPNOM = ?");
			params.add(vosalanos4os6.getEmpnom());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomre1() != null) {
			where.append(" AND t1.NOMRE1 = ?");
			params.add(vosalanos4os6.getNomre1());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesre1() != null) {
			where.append(" AND t1.DESRE1 = ?");
			params.add(vosalanos4os6.getDesre1());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomre2() != null) {
			where.append(" AND t1.NOMRE2 = ?");
			params.add(vosalanos4os6.getNomre2());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesre2() != null) {
			where.append(" AND t1.DESRE2 = ?");
			params.add(vosalanos4os6.getDesre2());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomre3() != null) {
			where.append(" AND t1.NOMRE3 = ?");
			params.add(vosalanos4os6.getNomre3());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesre3() != null) {
			where.append(" AND t1.DESRE3 = ?");
			params.add(vosalanos4os6.getDesre3());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomrep() != null) {
			where.append(" AND t1.NOMREP = ?");
			params.add(vosalanos4os6.getNomrep());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesrep() != null) {
			where.append(" AND t1.DESREP = ?");
			params.add(vosalanos4os6.getDesrep());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmppro() != null) {
			where.append(" AND t1.EMPPRO = ?");
			params.add(vosalanos4os6.getEmppro());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau01() != null) {
			where.append(" AND t1.CCAU01 = ?");
			params.add(vosalanos4os6.getCcau01());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau02() != null) {
			where.append(" AND t1.CCAU02 = ?");
			params.add(vosalanos4os6.getCcau02());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau03() != null) {
			where.append(" AND t1.CCAU03 = ?");
			params.add(vosalanos4os6.getCcau03());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau04() != null) {
			where.append(" AND t1.CCAU04 = ?");
			params.add(vosalanos4os6.getCcau04());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau05() != null) {
			where.append(" AND t1.CCAU05 = ?");
			params.add(vosalanos4os6.getCcau05());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau06() != null) {
			where.append(" AND t1.CCAU06 = ?");
			params.add(vosalanos4os6.getCcau06());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau07() != null) {
			where.append(" AND t1.CCAU07 = ?");
			params.add(vosalanos4os6.getCcau07());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau08() != null) {
			where.append(" AND t1.CCAU08 = ?");
			params.add(vosalanos4os6.getCcau08());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau09() != null) {
			where.append(" AND t1.CCAU09 = ?");
			params.add(vosalanos4os6.getCcau09());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau10() != null) {
			where.append(" AND t1.CCAU10 = ?");
			params.add(vosalanos4os6.getCcau10());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDirobr() != null) {
			where.append(" AND t1.DIROBR = ?");
			params.add(vosalanos4os6.getDirobr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecrev() != null) {
			where.append(" AND t1.FECREV = ?");
			params.add(vosalanos4os6.getFecrev());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumvis() != null) {
			where.append(" AND t1.NUMVIS = ?");
			params.add(vosalanos4os6.getNumvis());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNuecen() != null) {
			where.append(" AND t1.NUECEN = ?");
			params.add(vosalanos4os6.getNuecen());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodmod() != null) {
			where.append(" AND t1.CODMOD = ?");
			params.add(vosalanos4os6.getCodmod());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMopemp() != null) {
			where.append(" AND t1.MOPEMP = ?");
			params.add(vosalanos4os6.getMopemp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getForemp() != null) {
			where.append(" AND t1.FOREMP = ?");
			params.add(vosalanos4os6.getForemp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMoptra() != null) {
			where.append(" AND t1.MOPTRA = ?");
			params.add(vosalanos4os6.getMoptra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumtra() != null) {
			where.append(" AND t1.NUMTRA = ?");
			params.add(vosalanos4os6.getNumtra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFortra() != null) {
			where.append(" AND t1.FORTRA = ?");
			params.add(vosalanos4os6.getFortra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumtrf() != null) {
			where.append(" AND t1.NUMTRF = ?");
			params.add(vosalanos4os6.getNumtrf());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMopspp() != null) {
			where.append(" AND t1.MOPSPP = ?");
			params.add(vosalanos4os6.getMopspp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getSegspp() != null) {
			where.append(" AND t1.SEGSPP = ?");
			params.add(vosalanos4os6.getSegspp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getHigspp() != null) {
			where.append(" AND t1.HIGSPP = ?");
			params.add(vosalanos4os6.getHigspp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getErgspp() != null) {
			where.append(" AND t1.ERGSPP = ?");
			params.add(vosalanos4os6.getErgspp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedspp() != null) {
			where.append(" AND t1.MEDSPP = ?");
			params.add(vosalanos4os6.getMedspp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMopspa() != null) {
			where.append(" AND t1.MOPSPA = ?");
			params.add(vosalanos4os6.getMopspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomspa() != null) {
			where.append(" AND t1.NOMSPA = ?");
			params.add(vosalanos4os6.getNomspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getSegspa() != null) {
			where.append(" AND t1.SEGSPA = ?");
			params.add(vosalanos4os6.getSegspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getHigspa() != null) {
			where.append(" AND t1.HIGSPA = ?");
			params.add(vosalanos4os6.getHigspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getErgspa() != null) {
			where.append(" AND t1.ERGSPA = ?");
			params.add(vosalanos4os6.getErgspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedspa() != null) {
			where.append(" AND t1.MEDSPA = ?");
			params.add(vosalanos4os6.getMedspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getComsys() != null) {
			where.append(" AND t1.COMSYS = ?");
			params.add(vosalanos4os6.getComsys());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumcoe() != null) {
			where.append(" AND t1.NUMCOE = ?");
			params.add(vosalanos4os6.getNumcoe());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumcot() != null) {
			where.append(" AND t1.NUMCOT = ?");
			params.add(vosalanos4os6.getNumcot());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDelpre() != null) {
			where.append(" AND t1.DELPRE = ?");
			params.add(vosalanos4os6.getDelpre());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumdel() != null) {
			where.append(" AND t1.NUMDEL = ?");
			params.add(vosalanos4os6.getNumdel());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFordel() != null) {
			where.append(" AND t1.FORDEL = ?");
			params.add(vosalanos4os6.getFordel());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumdef() != null) {
			where.append(" AND t1.NUMDEF = ?");
			params.add(vosalanos4os6.getNumdef());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodmer() != null) {
			where.append(" AND t1.CODMER = ?");
			params.add(vosalanos4os6.getCodmer());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getIndrer() != null) {
			where.append(" AND t1.INDRER = ?");
			params.add(vosalanos4os6.getIndrer());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getReremo() != null) {
			where.append(" AND t1.REREMO = ?");
			params.add(vosalanos4os6.getReremo());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRertra() != null) {
			where.append(" AND t1.RERTRA = ?");
			params.add(vosalanos4os6.getRertra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRerspp() != null) {
			where.append(" AND t1.RERSPP = ?");
			params.add(vosalanos4os6.getRerspp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRerspa() != null) {
			where.append(" AND t1.RERSPA = ?");
			params.add(vosalanos4os6.getRerspa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRerotr() != null) {
			where.append(" AND t1.REROTR = ?");
			params.add(vosalanos4os6.getRerotr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDerotr() != null) {
			where.append(" AND t1.DEROTR = ?");
			params.add(vosalanos4os6.getDerotr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFirmer() != null) {
			where.append(" AND t1.FIRMER = ?");
			params.add(vosalanos4os6.getFirmer());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPardel() != null) {
			where.append(" AND t1.PARDEL = ?");
			params.add(vosalanos4os6.getPardel());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPartra() != null) {
			where.append(" AND t1.PARTRA = ?");
			params.add(vosalanos4os6.getPartra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCondel() != null) {
			where.append(" AND t1.CONDEL = ?");
			params.add(vosalanos4os6.getCondel());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTrainf() != null) {
			where.append(" AND t1.TRAINF = ?");
			params.add(vosalanos4os6.getTrainf());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedpla() != null) {
			where.append(" AND t1.MEDPLA = ?");
			params.add(vosalanos4os6.getMedpla());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedres() != null) {
			where.append(" AND t1.MEDRES = ?");
			params.add(vosalanos4os6.getMedres());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedfec() != null) {
			where.append(" AND t1.MEDFEC = ?");
			params.add(vosalanos4os6.getMedfec());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedpre() != null) {
			where.append(" AND t1.MEDPRE = ?");
			params.add(vosalanos4os6.getMedpre());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodmme() != null) {
			where.append(" AND t1.CODMME = ?");
			params.add(vosalanos4os6.getCodmme());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMeplac() != null) {
			where.append(" AND t1.MEPLAC = ?");
			params.add(vosalanos4os6.getMeplac());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getContra() != null) {
			where.append(" AND t1.CONTRA = ?");
			params.add(vosalanos4os6.getContra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMesimu() != null) {
			where.append(" AND t1.MESIMU = ?");
			params.add(vosalanos4os6.getMesimu());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmeemp() != null) {
			where.append(" AND t1.RMEEMP = ?");
			params.add(vosalanos4os6.getRmeemp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmetra() != null) {
			where.append(" AND t1.RMETRA = ?");
			params.add(vosalanos4os6.getRmetra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmespp() != null) {
			where.append(" AND t1.RMESPP = ?");
			params.add(vosalanos4os6.getRmespp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmespa() != null) {
			where.append(" AND t1.RMESPA = ?");
			params.add(vosalanos4os6.getRmespa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmeotr() != null) {
			where.append(" AND t1.RMEOTR = ?");
			params.add(vosalanos4os6.getRmeotr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDmeotr() != null) {
			where.append(" AND t1.DMEOTR = ?");
			params.add(vosalanos4os6.getDmeotr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFortrp() != null) {
			where.append(" AND t1.FORTRP = ?");
			params.add(vosalanos4os6.getFortrp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getVigsal() != null) {
			where.append(" AND t1.VIGSAL = ?");
			params.add(vosalanos4os6.getVigsal());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTrasen() != null) {
			where.append(" AND t1.TRASEN = ?");
			params.add(vosalanos4os6.getTrasen());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTramen() != null) {
			where.append(" AND t1.TRAMEN = ?");
			params.add(vosalanos4os6.getTramen());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTramat() != null) {
			where.append(" AND t1.TRAMAT = ?");
			params.add(vosalanos4os6.getTramat());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getInfnue() != null) {
			where.append(" AND t1.INFNUE = ?");
			params.add(vosalanos4os6.getInfnue());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPlaaco() != null) {
			where.append(" AND t1.PLAACO = ?");
			params.add(vosalanos4os6.getPlaaco());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNotas() != null) {
			where.append(" AND t1.NOTAS = ?");
			params.add(vosalanos4os6.getNotas());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNmutua() != null) {
			where.append(" AND t1.NMUTUA = ?");
			params.add(vosalanos4os6.getNmutua());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VosalanOs4Os6 entity.
	 * 
	 *  vosalanos4os6            VosalanOs4Os6 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vosalanos4os6 the vosalanos 4 os 6
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VosalanOs4Os6 vosalanos4os6,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VosalanOs4Os6DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		String mascara = Utilities.getInstance().getDateMask();

		if (vosalanos4os6 != null && vosalanos4os6.getTipoos() != null) {
			where.append(" AND UPPER(t1.TIPOOS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getTipoos().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getTipoos().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOOS IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodctr() != null) {
			where.append(" AND t1.CODCTR = ?");
			params.add(vosalanos4os6.getCodctr());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumdoc() != null) {
			where.append(" AND t1.NUMDOC = ?");
			params.add(vosalanos4os6.getNumdoc());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodano() != null) {
			where.append(" AND t1.CODANO = ?");
			params.add(vosalanos4os6.getCodano());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodpro() != null) {
			where.append(" AND UPPER(t1.CODPRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodpro().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodpro().toUpperCase() + "%");
			}
			where.append(" AND t1.CODPRO IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumeje() != null) {
			where.append(" AND t1.NUMEJE = ?");
			params.add(vosalanos4os6.getNumeje());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecvis() != null) {
			where.append(" AND t1.FECVIS = ?");
			params.add(vosalanos4os6.getFecvis());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecvisDesde() != null) {
			where.append(" AND TRUNC(t1.FECVIS) >= trunc(to_date(?, ?)) ");
			params.add(vosalanos4os6.getFecvisDesdeStr());
			params.add(mascara);
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecvisHasta() != null) {
			where.append(" AND TRUNC(t1.FECVIS) <= trunc(to_date(?, ?)) ");
			params.add(vosalanos4os6.getFecvisHastaStr());
			params.add(mascara);
		}

		if (vosalanos4os6 != null && vosalanos4os6.getCodtec() != null) {
			where.append(" AND UPPER(t1.CODTEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodtec().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodtec().toUpperCase() + "%");
			}
			where.append(" AND t1.CODTEC IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getObserv() != null) {
			where.append(" AND UPPER(t1.OBSERV) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getObserv().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getObserv().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERV IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodusa() != null) {
			where.append(" AND UPPER(t1.CODUSA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodusa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodusa().toUpperCase() + "%");
			}
			where.append(" AND t1.CODUSA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecusa() != null) {
			where.append(" AND t1.FECUSA = ?");
			params.add(vosalanos4os6.getFecusa());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodusm() != null) {
			where.append(" AND UPPER(t1.CODUSM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodusm().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodusm().toUpperCase() + "%");
			}
			where.append(" AND t1.CODUSM IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecusm() != null) {
			where.append(" AND t1.FECUSM = ?");
			params.add(vosalanos4os6.getFecusm());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(vosalanos4os6.getNumexp());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNompro() != null) {
			where.append(" AND UPPER(t1.NOMPRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNompro().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNompro().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMPRO IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomcon() != null) {
			where.append(" AND UPPER(t1.NOMCON) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomcon().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomcon().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMCON IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getAvipre() != null) {
			where.append(" AND UPPER(t1.AVIPRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getAvipre().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getAvipre().toUpperCase() + "%");
			}
			where.append(" AND t1.AVIPRE IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getComape() != null) {
			where.append(" AND UPPER(t1.COMAPE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getComape().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getComape().toUpperCase() + "%");
			}
			where.append(" AND t1.COMAPE IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPlaseg() != null) {
			where.append(" AND UPPER(t1.PLASEG) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getPlaseg().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getPlaseg().toUpperCase() + "%");
			}
			where.append(" AND t1.PLASEG IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomcoo() != null) {
			where.append(" AND UPPER(t1.NOMCOO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomcoo().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomcoo().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMCOO IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpcon() != null) {
			where.append(" AND UPPER(t1.EMPCON) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getEmpcon().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getEmpcon().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPCON IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpsub() != null) {
			where.append(" AND UPPER(t1.EMPSUB) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getEmpsub().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getEmpsub().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPSUB IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpaut() != null) {
			where.append(" AND UPPER(t1.EMPAUT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getEmpaut().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getEmpaut().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPAUT IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmpnom() != null) {
			where.append(" AND UPPER(t1.EMPNOM) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getEmpnom().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getEmpnom().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPNOM IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomre1() != null) {
			where.append(" AND UPPER(t1.NOMRE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomre1().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomre1().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRE1 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesre1() != null) {
			where.append(" AND UPPER(t1.DESRE1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDesre1().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDesre1().toUpperCase() + "%");
			}
			where.append(" AND t1.DESRE1 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomre2() != null) {
			where.append(" AND UPPER(t1.NOMRE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomre2().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomre2().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRE2 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesre2() != null) {
			where.append(" AND UPPER(t1.DESRE2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDesre2().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDesre2().toUpperCase() + "%");
			}
			where.append(" AND t1.DESRE2 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomre3() != null) {
			where.append(" AND UPPER(t1.NOMRE3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomre3().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomre3().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRE3 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesre3() != null) {
			where.append(" AND UPPER(t1.DESRE3) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDesre3().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDesre3().toUpperCase() + "%");
			}
			where.append(" AND t1.DESRE3 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomrep() != null) {
			where.append(" AND UPPER(t1.NOMREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomrep().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomrep().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMREP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDesrep() != null) {
			where.append(" AND UPPER(t1.DESREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDesrep().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDesrep().toUpperCase() + "%");
			}
			where.append(" AND t1.DESREP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getEmppro() != null) {
			where.append(" AND UPPER(t1.EMPPRO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getEmppro().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getEmppro().toUpperCase() + "%");
			}
			where.append(" AND t1.EMPPRO IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau01() != null) {
			where.append(" AND UPPER(t1.CCAU01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau01().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau01().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU01 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau02() != null) {
			where.append(" AND UPPER(t1.CCAU02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau02().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau02().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU02 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau03() != null) {
			where.append(" AND UPPER(t1.CCAU03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau03().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau03().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU03 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau04() != null) {
			where.append(" AND UPPER(t1.CCAU04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau04().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau04().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU04 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau05() != null) {
			where.append(" AND UPPER(t1.CCAU05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau05().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau05().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU05 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau06() != null) {
			where.append(" AND UPPER(t1.CCAU06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau06().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau06().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU06 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau07() != null) {
			where.append(" AND UPPER(t1.CCAU07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau07().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau07().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU07 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau08() != null) {
			where.append(" AND UPPER(t1.CCAU08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau08().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau08().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU08 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau09() != null) {
			where.append(" AND UPPER(t1.CCAU09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau09().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau09().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU09 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCcau10() != null) {
			where.append(" AND UPPER(t1.CCAU10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCcau10().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCcau10().toUpperCase() + "%");
			}
			where.append(" AND t1.CCAU10 IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDirobr() != null) {
			where.append(" AND UPPER(t1.DIROBR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDirobr().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDirobr().toUpperCase() + "%");
			}
			where.append(" AND t1.DIROBR IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFecrev() != null) {
			where.append(" AND t1.FECREV = ?");
			params.add(vosalanos4os6.getFecrev());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumvis() != null) {
			where.append(" AND t1.NUMVIS = ?");
			params.add(vosalanos4os6.getNumvis());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNuecen() != null) {
			where.append(" AND UPPER(t1.NUECEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNuecen().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNuecen().toUpperCase() + "%");
			}
			where.append(" AND t1.NUECEN IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodmod() != null) {
			where.append(" AND UPPER(t1.CODMOD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodmod().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodmod().toUpperCase() + "%");
			}
			where.append(" AND t1.CODMOD IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMopemp() != null) {
			where.append(" AND UPPER(t1.MOPEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMopemp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMopemp().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPEMP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getForemp() != null) {
			where.append(" AND UPPER(t1.FOREMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getForemp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getForemp().toUpperCase() + "%");
			}
			where.append(" AND t1.FOREMP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMoptra() != null) {
			where.append(" AND UPPER(t1.MOPTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMoptra().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMoptra().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPTRA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumtra() != null) {
			where.append(" AND t1.NUMTRA = ?");
			params.add(vosalanos4os6.getNumtra());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFortra() != null) {
			where.append(" AND UPPER(t1.FORTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getFortra().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getFortra().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumtrf() != null) {
			where.append(" AND t1.NUMTRF = ?");
			params.add(vosalanos4os6.getNumtrf());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMopspp() != null) {
			where.append(" AND UPPER(t1.MOPSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMopspp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMopspp().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPSPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getSegspp() != null) {
			where.append(" AND UPPER(t1.SEGSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getSegspp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getSegspp().toUpperCase() + "%");
			}
			where.append(" AND t1.SEGSPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getHigspp() != null) {
			where.append(" AND UPPER(t1.HIGSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getHigspp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getHigspp().toUpperCase() + "%");
			}
			where.append(" AND t1.HIGSPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getErgspp() != null) {
			where.append(" AND UPPER(t1.ERGSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getErgspp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getErgspp().toUpperCase() + "%");
			}
			where.append(" AND t1.ERGSPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedspp() != null) {
			where.append(" AND UPPER(t1.MEDSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMedspp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMedspp().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDSPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMopspa() != null) {
			where.append(" AND UPPER(t1.MOPSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMopspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMopspa().toUpperCase() + "%");
			}
			where.append(" AND t1.MOPSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNomspa() != null) {
			where.append(" AND UPPER(t1.NOMSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNomspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNomspa().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getSegspa() != null) {
			where.append(" AND UPPER(t1.SEGSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getSegspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getSegspa().toUpperCase() + "%");
			}
			where.append(" AND t1.SEGSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getHigspa() != null) {
			where.append(" AND UPPER(t1.HIGSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getHigspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getHigspa().toUpperCase() + "%");
			}
			where.append(" AND t1.HIGSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getErgspa() != null) {
			where.append(" AND UPPER(t1.ERGSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getErgspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getErgspa().toUpperCase() + "%");
			}
			where.append(" AND t1.ERGSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedspa() != null) {
			where.append(" AND UPPER(t1.MEDSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMedspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMedspa().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getComsys() != null) {
			where.append(" AND UPPER(t1.COMSYS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getComsys().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getComsys().toUpperCase() + "%");
			}
			where.append(" AND t1.COMSYS IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumcoe() != null) {
			where.append(" AND t1.NUMCOE = ?");
			params.add(vosalanos4os6.getNumcoe());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumcot() != null) {
			where.append(" AND t1.NUMCOT = ?");
			params.add(vosalanos4os6.getNumcot());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDelpre() != null) {
			where.append(" AND UPPER(t1.DELPRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDelpre().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDelpre().toUpperCase() + "%");
			}
			where.append(" AND t1.DELPRE IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumdel() != null) {
			where.append(" AND t1.NUMDEL = ?");
			params.add(vosalanos4os6.getNumdel());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFordel() != null) {
			where.append(" AND UPPER(t1.FORDEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getFordel().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getFordel().toUpperCase() + "%");
			}
			where.append(" AND t1.FORDEL IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNumdef() != null) {
			where.append(" AND t1.NUMDEF = ?");
			params.add(vosalanos4os6.getNumdef());
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodmer() != null) {
			where.append(" AND UPPER(t1.CODMER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodmer().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodmer().toUpperCase() + "%");
			}
			where.append(" AND t1.CODMER IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getIndrer() != null) {
			where.append(" AND UPPER(t1.INDRER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getIndrer().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getIndrer().toUpperCase() + "%");
			}
			where.append(" AND t1.INDRER IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getReremo() != null) {
			where.append(" AND UPPER(t1.REREMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getReremo().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getReremo().toUpperCase() + "%");
			}
			where.append(" AND t1.REREMO IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRertra() != null) {
			where.append(" AND UPPER(t1.RERTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRertra().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRertra().toUpperCase() + "%");
			}
			where.append(" AND t1.RERTRA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRerspp() != null) {
			where.append(" AND UPPER(t1.RERSPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRerspp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRerspp().toUpperCase() + "%");
			}
			where.append(" AND t1.RERSPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRerspa() != null) {
			where.append(" AND UPPER(t1.RERSPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRerspa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRerspa().toUpperCase() + "%");
			}
			where.append(" AND t1.RERSPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRerotr() != null) {
			where.append(" AND UPPER(t1.REROTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRerotr().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRerotr().toUpperCase() + "%");
			}
			where.append(" AND t1.REROTR IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDerotr() != null) {
			where.append(" AND UPPER(t1.DEROTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDerotr().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDerotr().toUpperCase() + "%");
			}
			where.append(" AND t1.DEROTR IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFirmer() != null) {
			where.append(" AND UPPER(t1.FIRMER) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getFirmer().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getFirmer().toUpperCase() + "%");
			}
			where.append(" AND t1.FIRMER IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPardel() != null) {
			where.append(" AND UPPER(t1.PARDEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getPardel().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getPardel().toUpperCase() + "%");
			}
			where.append(" AND t1.PARDEL IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPartra() != null) {
			where.append(" AND UPPER(t1.PARTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getPartra().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getPartra().toUpperCase() + "%");
			}
			where.append(" AND t1.PARTRA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCondel() != null) {
			where.append(" AND UPPER(t1.CONDEL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCondel().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCondel().toUpperCase() + "%");
			}
			where.append(" AND t1.CONDEL IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTrainf() != null) {
			where.append(" AND UPPER(t1.TRAINF) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getTrainf().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getTrainf().toUpperCase() + "%");
			}
			where.append(" AND t1.TRAINF IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedpla() != null) {
			where.append(" AND UPPER(t1.MEDPLA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMedpla().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMedpla().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPLA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedres() != null) {
			where.append(" AND UPPER(t1.MEDRES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMedres().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMedres().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDRES IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedfec() != null) {
			where.append(" AND UPPER(t1.MEDFEC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMedfec().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMedfec().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDFEC IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMedpre() != null) {
			where.append(" AND UPPER(t1.MEDPRE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMedpre().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMedpre().toUpperCase() + "%");
			}
			where.append(" AND t1.MEDPRE IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getCodmme() != null) {
			where.append(" AND UPPER(t1.CODMME) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getCodmme().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getCodmme().toUpperCase() + "%");
			}
			where.append(" AND t1.CODMME IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMeplac() != null) {
			where.append(" AND UPPER(t1.MEPLAC) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMeplac().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMeplac().toUpperCase() + "%");
			}
			where.append(" AND t1.MEPLAC IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getContra() != null) {
			where.append(" AND UPPER(t1.CONTRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getContra().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getContra().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTRA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getMesimu() != null) {
			where.append(" AND UPPER(t1.MESIMU) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getMesimu().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getMesimu().toUpperCase() + "%");
			}
			where.append(" AND t1.MESIMU IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmeemp() != null) {
			where.append(" AND UPPER(t1.RMEEMP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRmeemp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRmeemp().toUpperCase() + "%");
			}
			where.append(" AND t1.RMEEMP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmetra() != null) {
			where.append(" AND UPPER(t1.RMETRA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRmetra().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRmetra().toUpperCase() + "%");
			}
			where.append(" AND t1.RMETRA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmespp() != null) {
			where.append(" AND UPPER(t1.RMESPP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRmespp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRmespp().toUpperCase() + "%");
			}
			where.append(" AND t1.RMESPP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmespa() != null) {
			where.append(" AND UPPER(t1.RMESPA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRmespa().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRmespa().toUpperCase() + "%");
			}
			where.append(" AND t1.RMESPA IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getRmeotr() != null) {
			where.append(" AND UPPER(t1.RMEOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getRmeotr().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getRmeotr().toUpperCase() + "%");
			}
			where.append(" AND t1.RMEOTR IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getDmeotr() != null) {
			where.append(" AND UPPER(t1.DMEOTR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getDmeotr().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getDmeotr().toUpperCase() + "%");
			}
			where.append(" AND t1.DMEOTR IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getFortrp() != null) {
			where.append(" AND UPPER(t1.FORTRP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getFortrp().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getFortrp().toUpperCase() + "%");
			}
			where.append(" AND t1.FORTRP IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getVigsal() != null) {
			where.append(" AND UPPER(t1.VIGSAL) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getVigsal().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getVigsal().toUpperCase() + "%");
			}
			where.append(" AND t1.VIGSAL IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTrasen() != null) {
			where.append(" AND UPPER(t1.TRASEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getTrasen().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getTrasen().toUpperCase() + "%");
			}
			where.append(" AND t1.TRASEN IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTramen() != null) {
			where.append(" AND UPPER(t1.TRAMEN) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getTramen().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getTramen().toUpperCase() + "%");
			}
			where.append(" AND t1.TRAMEN IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getTramat() != null) {
			where.append(" AND UPPER(t1.TRAMAT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getTramat().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getTramat().toUpperCase() + "%");
			}
			where.append(" AND t1.TRAMAT IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getInfnue() != null) {
			where.append(" AND UPPER(t1.INFNUE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getInfnue().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getInfnue().toUpperCase() + "%");
			}
			where.append(" AND t1.INFNUE IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getPlaaco() != null) {
			where.append(" AND UPPER(t1.PLAACO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getPlaaco().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getPlaaco().toUpperCase() + "%");
			}
			where.append(" AND t1.PLAACO IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNotas() != null) {
			where.append(" AND UPPER(t1.NOTAS) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNotas().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNotas().toUpperCase() + "%");
			}
			where.append(" AND t1.NOTAS IS NOT NULL");
		}
		if (vosalanos4os6 != null && vosalanos4os6.getNmutua() != null) {
			where.append(" AND UPPER(t1.NMUTUA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vosalanos4os6.getNmutua().toUpperCase() + "%");
			} else {
				params.add("%" + vosalanos4os6.getNmutua().toUpperCase() + "%");
			}
			where.append(" AND t1.NMUTUA IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
